import { cn } from '@/lib/utils';

interface RatingProps {
  className?: string;
  rating: number;
  round?: number;
}

export function Rating({ className, rating, round }: RatingProps) {
  return (
    <div className={cn('kt-rating', className && className)}>
      {[...Array(5)].map((_, index) => (
        <div
          key={index}
          className={cn(
            'kt-rating-label',
            index < rating ? 'checked' : '',
            index === rating && round ? 'indeterminate' : '',
          )}
        >
          {index === rating && round ? (
            <svg viewBox="0 0 24 24" className="kt-rating-on size-4 leading-none" style={{ width: `${round * 100}%` }}>
              <path d="M14.2846 1.35037L16.3407 4.93481C16.4166 5.07417 16.5217 5.19547 16.6489 5.29037C16.776 5.38526 16.9222 5.45152 17.0774 5.48457L21.0357 6.38618C21.7202 6.5558 22.3108 6.98705 22.6809 7.58734C23.0509 8.18762 23.1708 8.90907 23.0148 9.59678C22.9154 10.0467 22.7078 10.4656 22.4101 10.8173L19.7163 13.9729C19.5167 14.2293 19.4189 14.5504 19.4414 14.8745L19.8372 19.0087C19.9155 19.7098 19.7167 20.4138 19.2833 20.9704C18.8499 21.5271 18.2161 21.8924 17.5172 21.9884C17.0658 22.0311 16.611 21.9553 16.1978 21.7685L12.4594 20.0862C12.1634 19.9652 11.8318 19.9652 11.5358 20.0862L7.83043 21.7245C7.50834 21.867 7.16097 21.9436 6.80881 21.9498C6.45664 21.956 6.10681 21.8916 5.77993 21.7604C5.45304 21.6292 5.15573 21.434 4.9055 21.1861C4.65527 20.9382 4.4572 20.6428 4.32295 20.3171C4.14356 19.8902 4.07182 19.4258 4.11404 18.9647L4.50987 14.8305C4.5255 14.6695 4.50927 14.5071 4.46211 14.3524C4.41494 14.1977 4.33777 14.0538 4.23499 13.9289L1.55216 10.7733C1.0982 10.2254 0.874342 9.52291 0.927655 8.81343C0.980969 8.10395 1.3073 7.44277 1.83803 6.96892C2.15333 6.6905 2.53014 6.49079 2.93756 6.38618L6.92882 5.49557C7.07703 5.45563 7.21523 5.3851 7.33453 5.28852C7.45383 5.19194 7.55159 5.07145 7.62152 4.93481L9.72161 1.35037C9.88963 1.04477 10.1173 0.776013 10.3911 0.560012C10.6649 0.344011 10.9792 0.185165 11.3155 0.0928846C11.6519 0.000604559 12.0033 -0.0232314 12.349 0.0227888C12.6946 0.068809 13.0276 0.183749 13.328 0.360799C13.7257 0.604199 14.0548 0.94473 14.2846 1.35037Z" fill="currentColor"/>
            </svg>
          ) : (
            <svg viewBox="0 0 24 24" className="kt-rating-on size-4 leading-none">
              <path d="M14.2846 1.35037L16.3407 4.93481C16.4166 5.07417 16.5217 5.19547 16.6489 5.29037C16.776 5.38526 16.9222 5.45152 17.0774 5.48457L21.0357 6.38618C21.7202 6.5558 22.3108 6.98705 22.6809 7.58734C23.0509 8.18762 23.1708 8.90907 23.0148 9.59678C22.9154 10.0467 22.7078 10.4656 22.4101 10.8173L19.7163 13.9729C19.5167 14.2293 19.4189 14.5504 19.4414 14.8745L19.8372 19.0087C19.9155 19.7098 19.7167 20.4138 19.2833 20.9704C18.8499 21.5271 18.2161 21.8924 17.5172 21.9884C17.0658 22.0311 16.611 21.9553 16.1978 21.7685L12.4594 20.0862C12.1634 19.9652 11.8318 19.9652 11.5358 20.0862L7.83043 21.7245C7.50834 21.867 7.16097 21.9436 6.80881 21.9498C6.45664 21.956 6.10681 21.8916 5.77993 21.7604C5.45304 21.6292 5.15573 21.434 4.9055 21.1861C4.65527 20.9382 4.4572 20.6428 4.32295 20.3171C4.14356 19.8902 4.07182 19.4258 4.11404 18.9647L4.50987 14.8305C4.5255 14.6695 4.50927 14.5071 4.46211 14.3524C4.41494 14.1977 4.33777 14.0538 4.23499 13.9289L1.55216 10.7733C1.0982 10.2254 0.874342 9.52291 0.927655 8.81343C0.980969 8.10395 1.3073 7.44277 1.83803 6.96892C2.15333 6.6905 2.53014 6.49079 2.93756 6.38618L6.92882 5.49557C7.07703 5.45563 7.21523 5.3851 7.33453 5.28852C7.45383 5.19194 7.55159 5.07145 7.62152 4.93481L9.72161 1.35037C9.88963 1.04477 10.1173 0.776013 10.3911 0.560012C10.6649 0.344011 10.9792 0.185165 11.3155 0.0928846C11.6519 0.000604559 12.0033 -0.0232314 12.349 0.0227888C12.6946 0.068809 13.0276 0.183749 13.328 0.360799C13.7257 0.604199 14.0548 0.94473 14.2846 1.35037Z" fill="currentColor"/>
            </svg>
          )}
          <svg viewBox="0 0 24 24" fill="none" className="kt-rating-off  size-4 leading-none">
            <path d="M7.26479 22.75C6.61177 22.7493 5.97686 22.5354 5.45662 22.1409C5.01826 21.8047 4.67272 21.3624 4.45252 20.8559C4.23231 20.3493 4.14469 19.7951 4.1979 19.2453L4.55753 15.4611C4.56166 15.4124 4.55582 15.3634 4.54036 15.3171C4.5249 15.2707 4.50015 15.228 4.46762 15.1915L2.01011 12.3558C1.65519 11.9314 1.41399 11.4237 1.30915 10.8806C1.2043 10.3374 1.23925 9.77654 1.41072 9.25058C1.57051 8.72657 1.86489 8.25357 2.26452 7.87867C2.66415 7.50377 3.15508 7.24007 3.68841 7.11383L7.26479 6.30507C7.3556 6.2758 7.43333 6.21576 7.48457 6.13533L9.34269 2.86032C9.59604 2.37477 9.97771 1.96793 10.4462 1.68402C10.9147 1.40011 11.4521 1.25 12 1.25C12.5479 1.25 13.0853 1.40011 13.5538 1.68402C14.0223 1.96793 14.404 2.37477 14.6573 2.86032L16.5154 6.13533C16.5667 6.21576 16.6444 6.2758 16.7352 6.30507L20.3116 7.11383C20.8449 7.24007 21.3359 7.50377 21.7355 7.87867C22.1351 8.25357 22.4295 8.72657 22.5893 9.25058C22.7607 9.77654 22.7957 10.3374 22.6909 10.8806C22.586 11.4237 22.3448 11.9314 21.9899 12.3558L19.5623 15.1915C19.5298 15.228 19.5051 15.2707 19.4896 15.3171C19.4741 15.3634 19.4683 15.4124 19.4724 15.4611L19.8321 19.2453C19.8853 19.7951 19.7977 20.3493 19.5775 20.8559C19.3573 21.3624 19.0117 21.8047 18.5733 22.1409C18.1431 22.4664 17.6329 22.6698 17.0966 22.7296C16.5603 22.7893 16.0178 22.7032 15.5264 22.4804L12.1399 21.0027C12.0959 20.9828 12.0482 20.9725 12 20.9725C11.9518 20.9725 11.9041 20.9828 11.8601 21.0027L8.50354 22.4804C8.11458 22.6575 7.69222 22.7495 7.26479 22.75ZM12 2.72053C11.7016 2.72264 11.4091 2.80424 11.1527 2.95693C10.8964 3.10962 10.6854 3.32788 10.5415 3.58921L8.68336 6.86422C8.56713 7.0754 8.40723 7.25942 8.21431 7.40404C8.02139 7.54865 7.79987 7.65055 7.56449 7.70294L4.00809 8.52169C3.71106 8.58441 3.43646 8.72603 3.21318 8.93162C2.98991 9.13721 2.82622 9.39916 2.73937 9.68991C2.64569 9.97984 2.62771 10.2889 2.68716 10.5877C2.74661 10.8866 2.8815 11.1652 3.07903 11.3973L5.51656 14.233C5.83326 14.6152 5.98747 15.1063 5.94613 15.6009L5.58649 19.3851C5.55018 19.6914 5.59469 20.0019 5.71562 20.2856C5.83654 20.5694 6.02967 20.8166 6.27579 21.0027C6.5104 21.1828 6.78967 21.2956 7.0836 21.329C7.37753 21.3624 7.67501 21.3152 7.9441 21.1924L11.3107 19.6747C11.527 19.5759 11.7621 19.5247 12 19.5247C12.2379 19.5247 12.473 19.5759 12.6893 19.6747L16.0559 21.1924C16.325 21.3152 16.6225 21.3624 16.9164 21.329C17.2103 21.2956 17.4896 21.1828 17.7242 21.0027C17.9657 20.8193 18.1559 20.577 18.2766 20.299C18.3973 20.021 18.4445 19.7166 18.4135 19.4151L18.0539 15.6309C18.0125 15.1363 18.1667 14.6452 18.4834 14.2629L20.921 11.4273C21.1185 11.1952 21.2534 10.9165 21.3128 10.6177C21.3723 10.3189 21.3543 10.0098 21.2606 9.71986C21.1784 9.42357 21.0168 9.15535 20.7932 8.94418C20.5696 8.73302 20.2925 8.58692 19.9919 8.52169L16.4055 7.70294C16.1702 7.65055 15.9486 7.54865 15.7557 7.40404C15.5628 7.25942 15.4029 7.0754 15.2867 6.86422L13.4585 3.58921C13.3146 3.32788 13.1036 3.10962 12.8473 2.95693C12.5909 2.80424 12.2984 2.72264 12 2.72053Z" fill="currentColor"/>
          </svg>
        </div>
      ))}
    </div>
  );
}
