'use client';

import { Fragment } from 'react';
import Link from 'next/link';
import {
  Activity,
  BarChart,
  ChevronDown,
  Database,
  FileText,
  Lock,
  Share2,
  Star,
  Users,
} from 'lucide-react';
import { cn } from '@/lib/utils';
import {
  AccordionMenu,
  AccordionMenuItem,
  AccordionMenuSeparator,
  AccordionMenuSub,
  AccordionMenuSubContent,
  AccordionMenuSubTrigger,
} from '@/components/ui/accordion-menu';

export function SidebarMenuSecondary() {
  const items = [
    {
      title: 'Spaces',
      value: 'spaces',
      plus: true,
      children: [
        {
          icon: BarChart,
          title: 'Metrics Hub',
          path: '/layout-6/empty',
        },
        {
          icon: Database,
          title: 'Data Lab',
          active: true,
          path: '/layout-6/empty',
        },
        {
          icon: Share2,
          title: 'Creative Commons',
          path: '/layout-6/empty',
        },
        {
          icon: Activity,
          title: 'KPI Monitor',
          path: '/layout-6/empty',
        },
      ],
    },
    {
      title: 'Favorites',
      value: 'favorites',
      plus: false,
      children: [
        {
          icon: Star,
          title: 'Post Date',
          path: '/layout-6/empty',
        },
        {
          icon: FileText,
          title: 'Licencias Creative',
          path: '/layout-6/empty',
        },
        {
          icon: Users,
          title: 'Open Content',
          path: '/layout-6/empty',
        },
        { icon: Lock, title: 'Copyright', path: '/layout-6/empty' },
      ],
    },
  ];

  const classNames = {
    root: 'flex flex-col w-full gap-1.5 px-3.5',
    group: 'gap-px',
    item: 'group h-9 hover:bg-transparent border border-transparent text-accent-foreground hover:text-primary hover:bg-background hover:border-border data-[selected=true]:text-primary data-[selected=true]:bg-background data-[selected=true]:border-border data-[selected=true]:font-medium',
    sub: '',
    subTrigger:
      'justify-between h-9 hover:bg-transparent border border-transparent text-accent-foreground hover:text-primary data-[selected=true]:text-primary data-[selected=true]:bg-background data-[selected=true]:border-border data-[selected=true]:font-medium [&_[data-slot=accordion-menu-sub-indicator]]:hidden',
    subContent: 'p-0',
    subWrapper: 'space-y-1.5',
    indicator: 'text-sm text-muted-foreground',
  };

  return (
    <>
      <AccordionMenu
        type="single"
        collapsible
        classNames={classNames}
        defaultValue="spaces"
      >
        {items.map((item, index) => (
          <Fragment key={index}>
            <AccordionMenuSub value={item.value}>
              <AccordionMenuSubTrigger>
                <div className="flex items-center gap-2">
                  <ChevronDown className={cn('text-sm')} />
                  <span>{item.title}</span>
                </div>
              </AccordionMenuSubTrigger>
              <AccordionMenuSubContent
                type="single"
                collapsible
                parentValue={item.value}
              >
                {item.children.map((child, childIndex) => (
                  <AccordionMenuItem
                    key={childIndex}
                    value={child.path}
                    className={cn(child.active && 'active')}
                  >
                    <Link href={child.path} className="flex items-center gap-2">
                      {child.icon && (
                        <span className="rounded-md size-7 flex items-center justify-center border border-border text-foreground group-hover:border-transparent">
                          <child.icon className="size-4" />
                        </span>
                      )}
                      {child.title}
                    </Link>
                  </AccordionMenuItem>
                ))}
              </AccordionMenuSubContent>
            </AccordionMenuSub>
            {index !== items.length - 1 && (
              <AccordionMenuSeparator className="border-b border-input my-2 mx-1.5" />
            )}
          </Fragment>
        ))}
      </AccordionMenu>
    </>
  );
}
