'use client';

import Link from 'next/link';
import { RiFacebookCircleLine, RiYoutubeLine } from '@remixicon/react';
import {
  BriefcaseBusiness,
  Crown,
  Luggage,
  Mail,
  Volleyball,
} from 'lucide-react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';

const Summary = ({ title }) => {
  const items = [
    { icon: Luggage, info: 'KeenThemes' },
    { icon: Crown, info: 'Author' },
    { icon: BriefcaseBusiness, info: 'UI/UX Desiger' },
    { icon: Mail, info: 'enny@kteam.com' },
    { icon: Volleyball, info: 'https://keenthemes.com' },
    { icon: RiFacebookCircleLine, info: 'keenthemes' },
    { icon: RiYoutubeLine, info: 'keenthemes' },
  ];

  const renderItem = (item, index) => {
    return (
      <div key={index} className="flex items-center gap-2.5">
        <item.icon className="text-base text-muted-foreground" size={16} />
        <Link
          href="#"
          className="text-sm leading-none text-mono hover:text-primary-active"
        >
          {item.info}
        </Link>
      </div>
    );
  };

  return (
    <Card>
      <CardHeader>
        <CardTitle>{title}</CardTitle>
      </CardHeader>
      <CardContent>
        <p className="text-sm text-foreground leading-5.5 mb-4">
          Experienced and creative professional with a passion great as for
          problem-solving and a commitment to excellence.
        </p>
        <div className="grid gap-y-5">
          {items.map((item, index) => {
            return renderItem(item, index);
          })}
        </div>
      </CardContent>
    </Card>
  );
};

export { Summary };
