import { Contact } from '../types/contact';
import { toAbsoluteUrl } from '@/lib/helpers';

function getRandomSocialLinks(): Record<string, string> {
  const platforms = ['linkedin', 'twitter', 'github', 'instagram', 'facebook', 'youtube', 'medium', 'stackoverflow'];
  const selected = new Set<string>();
  
  while (selected.size < 2) {
    const randomIndex = Math.floor(Math.random() * platforms.length);
    selected.add(platforms[randomIndex]);
  }
  
  return Array.from(selected).reduce((acc, platform) => {
    acc[platform] = `https://${platform}.com/contact_123`;
    return acc;
  }, {} as Record<string, string>);
}

export const mockContacts: Contact[] = [
  // Today's contacts
  {
    id: '1',
    address: '456 Market St',
    socialLinks: getRandomSocialLinks(),
    name: 'Chris Lee',
    avatar: '/media/avatars/300-6.png',
    initials: 'R',
    email: 'chris.lee@example.com',
    phone: '+1 555-0123',
    position: 'CEO',
    company: 'TBG Corporation',
    logo: toAbsoluteUrl('/media/brand-logos/tbg.svg'),
    createdAt: new Date(Date.now()),
    updatedAt: new Date(Date.now()),
  },
  {
    id: '2',
    address: '789 Oak St',
    socialLinks: getRandomSocialLinks(),
    name: 'Emily Davis',
    avatar: '/media/avatars/300-23.png',
    email: 'emily.davis@example.com',
    phone: '+1 555-0124',
    position: 'CTO',
    company: 'Globex Inc',
    logo: toAbsoluteUrl('/media/brand-logos/android.svg'),
    createdAt: new Date(Date.now() - 1 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 1 * 60 * 60 * 1000),
  },
  {
    id: '7',
    address: '1234 Tech St',
    socialLinks: getRandomSocialLinks(),
    name: 'David Wilson',
    avatar: '/media/avatars/300-10.png',
    initials: 'D',
    email: 'david.wilson@example.com',
    phone: '+1 555-0127',
    position: 'Data Scientist',
    company: 'DataTech',
    logo: toAbsoluteUrl('/media/brand-logos/bithumb.svg'),
    createdAt: new Date(Date.now()),
    updatedAt: new Date(Date.now()),
  },
  {
    id: '8',
    address: '5678 Innovation Ave',
    socialLinks: getRandomSocialLinks(),
    name: 'Sophie Chen',
    avatar: '/media/avatars/300-11.png',
    initials: 'S',
    email: 'sophie.chen@example.com',
    phone: '+1 555-0128',
    position: 'AI Engineer',
    company: 'AI Labs',
    logo: toAbsoluteUrl('/media/brand-logos/btcchina.svg'),
    createdAt: new Date(Date.now()),
    updatedAt: new Date(Date.now()),
  },
  {
    id: '9',
    address: '9012 Digital Rd',
    socialLinks: getRandomSocialLinks(),
    name: 'Thomas Anderson',
    avatar: '/media/avatars/300-12.png',
    initials: 'T',
    email: 'thomas.anderson@example.com',
    phone: '+1 555-0129',
    position: 'Blockchain Developer',
    company: 'CryptoTech',
    logo: toAbsoluteUrl('/media/brand-logos/coinhodler.svg'),
    createdAt: new Date(Date.now()),
    updatedAt: new Date(Date.now()),
  },
  {
    id: '15',
    address: '10880 Malibu Point',
    socialLinks: getRandomSocialLinks(),
    name: 'Tony Stark',
    avatar: '/media/avatars/300-1.png',
    initials: 'T',
    email: 'tony.stark@starkindustries.com',
    phone: '+1 555-0115',
    position: 'CEO',
    company: 'Stark Industries',
    logo: toAbsoluteUrl('/media/brand-logos/btcchina.svg'),
    createdAt: new Date(Date.now()),
    updatedAt: new Date(Date.now()),
  },
  {
    id: '17',
    address: '10880 Malibu Point',
    socialLinks: getRandomSocialLinks(),
    name: 'Pepper Potts',
    avatar: '/media/avatars/300-2.png',
    initials: 'P',
    email: 'pepper.potts@starkindustries.com',
    phone: '+1 555-0117',
    position: 'CEO Assistant',
    company: 'Stark Industries',
    logo: toAbsoluteUrl('/media/brand-logos/btcchina.svg'),
    createdAt: new Date(Date.now()),
    updatedAt: new Date(Date.now()),
  },

  // Yesterday's contacts
  {
    id: '3',
    address: '321 Pine St',
    socialLinks: getRandomSocialLinks(),
    name: 'Mike Johnson',
    avatar: '/media/avatars/300-7.png',
    email: 'bob@example.com',
    phone: '+1 555-0125',
    position: 'Developer',
    company: 'Initech',
    logo: toAbsoluteUrl('/media/brand-logos/bridgefy.svg'),
    createdAt: new Date(Date.now() - 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 24 * 60 * 60 * 1000),
  },
  {
    id: '4',
    address: '901 Maple St',
    socialLinks: getRandomSocialLinks(),
    name: 'Lisa Brown',
    avatar: '/media/avatars/300-17.png',
    email: 'alice@example.com',
    phone: '+1 555-0126',
    position: 'Designer',
    company: 'Umbrella Corp',
    logo: toAbsoluteUrl('/media/brand-logos/coinhodler.svg'),
    createdAt: new Date(Date.now() - 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 24 * 60 * 60 * 1000),
  },

  // This Week's contacts
  {
    id: '5',
    address: '234 Cedar St',
    socialLinks: getRandomSocialLinks(),
    name: 'John Smith',
    avatar: '/media/avatars/300-1.png',
    email: 'john.smith@example.com',
    phone: '+1 555-0129',
    position: 'Manager',
    company: 'Tech Solutions',
    logo: toAbsoluteUrl('/media/brand-logos/btcexchange.svg'),
    createdAt: new Date(Date.now() - 3 * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 3 * 24 * 60 * 60 * 1000),
  },
  {
    id: '6',
    address: '567 Spruce St',
    socialLinks: getRandomSocialLinks(),
    name: 'Jane Doe',
    avatar: '/media/avatars/300-2.png',
    email: 'jane.doe@example.com',
    phone: '+1 555-0130',
    position: 'Consultant',
    company: 'Digital Innovations',
    logo: toAbsoluteUrl('/media/brand-logos/discord.svg'),
    createdAt: new Date(Date.now() - 4 * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 4 * 24 * 60 * 60 * 1000),
  },
  {
    id: '7',
    address: '890 Walnut St',
    socialLinks: getRandomSocialLinks(),
    name: 'Bob Johnson',
    avatar: '/media/avatars/300-3.png',
    initials: 'B',
    email: 'bob.j@example.com',
    phone: '+1 555-0131',
    position: 'Developer',
    company: 'Initech',
    logo: toAbsoluteUrl('/media/brand-logos/bridgefy.svg'),
    createdAt: new Date(Date.now() - 5 * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 5 * 24 * 60 * 60 * 1000),
  },
  {
    id: '8',
    address: '345 Chestnut St',
    socialLinks: getRandomSocialLinks(),
    name: 'Alice Smith',
    avatar: '/media/avatars/300-4.png',
    email: 'alice.s@example.com',
    phone: '+1 555-0132',
    position: 'Designer',
    company: 'Umbrella Corp',
    logo: toAbsoluteUrl('/media/brand-logos/coinhodler.svg'),
    createdAt: new Date(Date.now() - 6 * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() - 6 * 24 * 60 * 60 * 1000),
  },

  // Last week's contacts
  {
    id: '5',
    address: '678 Elm St',
    socialLinks: getRandomSocialLinks(),
    name: 'Charlie Wilson',
    avatar: '/media/avatars/300-5.png',
    email: 'charlie@example.com',
    phone: '+1 555-0127',
    position: 'Manager',
    company: 'Acme Corp',
    logo: toAbsoluteUrl('/media/brand-logos/twitter.svg'),
    createdAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
  },
  {
    id: '6',
    address: '901 Oak St',
    socialLinks: getRandomSocialLinks(),
    name: 'Sarah Martinez',
    avatar: '/media/avatars/300-20.png',
    email: 'diana@example.com',
    phone: '+1 555-0128',
    position: 'Analyst',
    company: 'Widget Co',
    logo: toAbsoluteUrl('/media/brand-logos/foursquare.svg'),
    createdAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
  },

  // Older contacts
  {
    id: '7',
    address: '234 Maple St',
    socialLinks: getRandomSocialLinks(),
    name: 'Karen Walker',
    avatar: '/media/avatars/300-22.png',
    email: 'frank@example.com',
    phone: '+1 555-0129',
    position: 'Engineer',
    company: 'Tech Solutions',
    logo: toAbsoluteUrl('/media/brand-logos/btcexchange.svg'),
    createdAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
  },
  {
    id: '2',
    address: '456 Market St',
    socialLinks: getRandomSocialLinks(),
    avatar: '/media/avatars/300-11.png',
    name: 'Jane Smith',
    email: 'jane.smith@example.com',
    phone: '+1-555-1002',
    position: 'CTO',
    company: 'Globex Inc',
    city: 'New York',
    state: 'NY',
    zip: '10001',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/general-electric.svg'),
    createdAt: new Date(),
    updatedAt: new Date('2024-05-26T17:00:00Z'),
  },
  {
    id: '3',
    address: '789 Oak St',
    socialLinks: getRandomSocialLinks(),
    avatar: '/media/avatars/300-2.png',
    initials: 'M',
    name: 'Mike Johnson',
    email: 'mike.johnson@example.com',
    phone: '+1-555-1003',
    position: 'CFO',
    company: 'Initech',
    city: 'Austin',
    state: 'TX',
    zip: '73301',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/gitlab.svg'),
    createdAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
    updatedAt: new Date(Date.now() + Math.floor(Math.random() * 7) * 24 * 60 * 60 * 1000),
  },
  {
    id: '4',
    address: '901 Maple St',
    socialLinks: getRandomSocialLinks(),
    avatar: '/media/avatars/300-12.png',
    name: 'Emily Davis',
    email: 'emily.davis@example.com',
    phone: '+1-555-1004',
    position: 'COO',
    company: 'Umbrella Corp',
    city: 'Chicago',
    state: 'IL',
    zip: '60601',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/spotify-2.svg'),
    createdAt: new Date('2020-05-20T12:00:00Z'),
    updatedAt: new Date('2024-05-26T17:00:00Z'),
  },
  {
    id: '5',
    socialLinks: getRandomSocialLinks(),
    avatar: '/media/avatars/300-6.png',
    name: 'Chris Lee',
    email: 'chris.lee@example.com',
    phone: '+1-555-1005',
    position: 'VP of Sales',
    company: 'Marketing Agency',
    address: '234 Cedar St',
    city: 'Palo Alto',
    state: 'CA',
    zip: '94301',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/instagram.svg'),
    createdAt: new Date('2023-09-15T13:00:00Z'),
    updatedAt: new Date('2024-05-25T16:00:00Z'),
  },
  {
    id: '6',
    socialLinks: getRandomSocialLinks(),
    avatar: '/media/avatars/300-17.png',
    name: 'Lisa Brown',
    email: 'lisa.brown@example.com',
    phone: '+1-555-1006',
    position: 'VP of Marketing',
    company: 'TBG Corporation',
    address: '567 Spruce St',
    city: 'Denver',
    state: 'CO',
    zip: '80201',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/whatsapp.svg'),
    createdAt: new Date('2022-08-19T08:00:00Z'),
    updatedAt: new Date('2024-05-12T03:00:00Z'),
  },
  {
    id: '7',
    socialLinks: getRandomSocialLinks(),
    avatar: '/media/avatars/300-21.png',
    name: 'Donna Young',
    email: 'donna.young@example.com',
    phone: '+1-555-1018',
    position: 'Content Strategist',
    company: 'Widget Co',
    address: '890 Walnut St',
    city: 'Houston',
    state: 'TX',
    zip: '77001',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/facebook.svg'),
    createdAt: new Date('2022-08-19T08:00:00Z'),
    updatedAt: new Date('2024-05-12T03:00:00Z'),
  },
  {
    id: '19',
    socialLinks: getRandomSocialLinks(),
    avatar: '',
    initials: 'P',
    name: 'Paul King',
    email: 'paul.king@example.com',
    phone: '+1-555-1019',
    position: 'Support Engineer',
    company: 'Acme Corp',
    address: '321 Wall St',
    city: 'Detroit',
    state: 'MI',
    zip: '48201',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/apple-black.svg'),
    createdAt: new Date('2021-06-13T07:00:00Z'),
    updatedAt: new Date('2024-05-11T02:00:00Z'),
  },
  {
    id: '20',
    socialLinks: getRandomSocialLinks(),
    avatar: 'https://randomuser.me/api/portraits/women/30.jpg',
    name: 'Barbara Scott',
    email: 'barbara.scott@example.com',
    phone: '+1-555-1020',
    position: 'Office Manager',
    company: 'Marketing Agency',
    address: '456 Market St',
    city: 'Palo Alto',
    state: 'CA',
    zip: '94301',
    country: 'USA',
    logo: toAbsoluteUrl('/media/brand-logos/airbnb-2.svg'),
    createdAt: new Date('2020-02-11T06:00:00Z'),
    updatedAt: new Date('2024-05-10T01:00:00Z'),
  },
];