import { toAbsoluteUrl } from '@/lib/helpers';
import { Deal } from '@/app/crm/types/deal';

export const mockDeals: Deal[] = [
  // Active (today) tab deals
  {
    id: '1',
    title: 'Website Redesign Project',
    content: 'Redesigning the company website with modern UI/UX improvements',
    status: 'In progress',
    priority: 'high',
    contactIds: ['1'],
    userName: 'Emma Johnson',
    avatar: toAbsoluteUrl('/media/avatars/300-1.png'),
    dueAt: new Date('2024-07-10'), // Today
    createdAt: new Date('2025-07-01'),
    updatedAt: new Date('2024-07-10'),
    comments: 3,
    amount: 15000,
    currency: 'USD',
    paymentDate: new Date('2025-07-15'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-001',
    discount: 4,
  },
  {
    id: '2',
    title: 'Mobile App Development',
    content: 'Developing a native mobile application for iOS and Android',
    status: 'In progress',
    priority: 'medium',
    contactIds: ['2'],
    userName: 'James Wilson',
    avatar: toAbsoluteUrl('/media/avatars/300-2.png'),
    dueAt: new Date('2024-07-10'), // Today
    createdAt: new Date('2025-07-05'),
    updatedAt: new Date('2024-07-10'),
    comments: 2,
    amount: 25000,
    currency: 'EUR',
    paymentDate: new Date('2025-07-17'),
    paymentType: 'invoice',
    contractNumber: 'INV-2025-002',
    discount: 5,
  },
  {
    id: '3',
    title: 'Social Media Campaign',
    content: 'Planning and executing a social media marketing campaign',
    status: 'in_progress',
    priority: 'low',
    contactIds: ['3'],
    userName: 'Olivia Brown',
    avatar: toAbsoluteUrl('/media/avatars/300-13.png'),
    dueAt: new Date('2024-07-10'), // Today
    createdAt: new Date('2025-07-08'),
    updatedAt: new Date('2024-07-10'),
    comments: 1,
    amount: 10000,
    currency: 'RUB',
    paymentDate: new Date('2025-07-19'),
    paymentType: 'cash',
    contractNumber: 'INV-2025-003',
    discount: 2,
  },
  {
    id: '4',
    title: 'SEO Optimization',
    content: 'Improving website search engine rankings and organic traffic',
    status: 'in_progress',
    priority: 'medium',
    contactIds: ['4'],
    userName: 'Sarah Wilson',
    avatar: toAbsoluteUrl('/media/avatars/300-4.png'),
    dueAt: new Date('2024-07-10'), // Today
    createdAt: new Date('2025-07-07'),
    updatedAt: new Date('2024-07-10'),
    comments: 4,
    amount: 18000,
    currency: 'USD',
    paymentDate: new Date('2025-07-21'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-004',
    discount: 3,
  },
  {
    id: '5',
    title: 'Branding Strategy',
    content: 'Developing a comprehensive branding strategy and guidelines',
    status: 'in_progress',
    priority: 'high',
    contactIds: ['4'],
    userName: 'Michael Chen',
    avatar: toAbsoluteUrl('/media/avatars/300-18.png'),
    dueAt: new Date('2024-07-12'),
    createdAt: new Date('2025-07-02'),
    updatedAt: new Date('2024-07-10'),
    comments: 4,
    amount: 18000,
    currency: 'USD',
    paymentDate: new Date('2025-07-14'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-004',
    discount: 5,
  },
  {
    id: '6',
    title: 'Digital Marketing Campaign',
    content: 'Running a multi-channel digital marketing campaign',
    status: 'in_progress',
    priority: 'medium',
    contactIds: ['5'],
    userName: 'Sarah Wilson',
    avatar: toAbsoluteUrl('/media/avatars/300-23.png'),
    dueAt: new Date('2024-07-14'),
    createdAt: new Date('2025-07-06'),
    updatedAt: new Date('2024-07-10'),
    comments: 3,
    amount: 15000,
    currency: 'RUB',
    paymentDate: new Date('2025-07-15'),
    paymentType: 'invoice',
    contractNumber: 'INV-2025-005',
    discount: 4,
  },
  // Closed (week) tab deals
  {
    id: '7',
    title: 'Completed Website Redesign',
    content: 'Successfully completed website redesign project',
    status: 'completed',
    priority: 'high',
    contactIds: ['1'],
    userName: 'Michael Brown',
    avatar: toAbsoluteUrl('/media/avatars/300-14.png'),
    dueAt: new Date('2024-07-03'),
    createdAt: new Date('2025-06-25'),
    updatedAt: new Date('2024-07-03'),
    comments: 3,
    amount: 15000,
    currency: 'USD',
    paymentDate: new Date('2025-07-15'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-001',
    discount: 7,
  },
  {
    id: '6',
    title: 'Completed Mobile App',
    content: 'Successfully completed mobile app development',
    status: 'completed',
    priority: 'medium',
    contactIds: ['2'],
    userName: 'William Davis',
    avatar: toAbsoluteUrl('/media/avatars/300-6.png'),
    dueAt: new Date('2024-07-05'),
    createdAt: new Date('2025-06-28'),
    updatedAt: new Date('2024-07-05'),
    comments: 2,
    amount: 25000,
    currency: 'EUR',
    paymentDate: new Date('2025-07-17'),
    paymentType: 'invoice',
    contractNumber: 'INV-2025-002',
    discount: 5,
  },
  {
    id: '7',
    title: 'Completed Marketing',
    content: 'Successfully completed social media campaign',
    status: 'completed',
    priority: 'low',
    contactIds: ['3'],
    userName: 'Ava Lee',
    avatar: toAbsoluteUrl('/media/avatars/300-7.png'),
    dueAt: new Date('2024-07-07'),
    createdAt: new Date('2025-06-30'),
    updatedAt: new Date('2024-07-07'),
    comments: 1,
    amount: 10000,
    currency: 'RUB',
    paymentDate: new Date('2025-07-19'),
    paymentType: 'cash',
    contractNumber: 'INV-2025-003',
    discount: 2,
  },
  {
    id: '8',
    title: 'Completed SEO',
    content: 'Successfully completed SEO optimization',
    status: 'completed',
    priority: 'medium',
    contactIds: ['4'],
    userName: 'Isabella Taylor',
    avatar: toAbsoluteUrl('/media/avatars/300-8.png'),
    dueAt: new Date('2024-07-09'),
    createdAt: new Date('2025-06-29'),
    updatedAt: new Date('2024-07-09'),
    comments: 4,
    amount: 18000,
    currency: 'USD',
    paymentDate: new Date('2025-07-21'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-004',
    discount: 3,
  },
  // Upcoming (completed) tab deals
  {
    id: '9',
    title: 'Future Website Project',
    content: 'Upcoming website redesign project',
    status: 'pending',
    priority: 'high',
    contactIds: ['1'],
    userName: 'Ethan Hall',
    avatar: toAbsoluteUrl('/media/avatars/300-9.png'),
    dueAt: new Date('2024-07-15'),
    createdAt: new Date('2025-07-10'),
    updatedAt: new Date('2024-07-10'),
    comments: 3,
    amount: 15000,
    currency: 'USD',
    paymentDate: new Date('2025-07-15'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-001',
    discount: 0,
  },
  {
    id: '10',
    title: 'Future Mobile App',
    content: 'Upcoming mobile app development',
    status: 'pending',
    priority: 'medium',
    contactIds: ['2'],
    userName: 'Liam Martin',
    avatar: toAbsoluteUrl('/media/avatars/300-16.png'),
    dueAt: new Date('2024-07-17'),
    createdAt: new Date('2025-07-10'),
    updatedAt: new Date('2024-07-10'),
    comments: 2,
    amount: 25000,
    currency: 'EUR',
    paymentDate: new Date('2025-07-17'),
    paymentType: 'invoice',
    contractNumber: 'INV-2025-002',
    discount: 5,
  },
  {
    id: '11',
    title: 'Future Marketing',
    content: 'Upcoming social media campaign',
    status: 'pending',
    priority: 'low',
    contactIds: ['3'],
    userName: 'Sophia Patel',
    avatar: toAbsoluteUrl('/media/avatars/300-11.png'),
    dueAt: new Date('2024-07-19'),
    createdAt: new Date('2025-07-10'),
    updatedAt: new Date('2024-07-10'),
    comments: 1,
    amount: 10000,
    currency: 'RUB',
    paymentDate: new Date('2025-07-19'),
    paymentType: 'cash',
    contractNumber: 'INV-2025-003',
    discount: 2,
  },
  {
    id: '12',
    title: 'Future SEO',
    content: 'Upcoming SEO optimization',
    status: 'pending',
    priority: 'medium',
    contactIds: ['4'],
    userName: 'Mia Kim',
    avatar: toAbsoluteUrl('/media/avatars/300-15.png'),
    dueAt: new Date('2024-07-21'),
    createdAt: new Date('2025-07-10'),
    updatedAt: new Date('2024-07-10'),
    comments: 4,
    amount: 18000,
    currency: 'USD',
    paymentDate: new Date('2025-07-21'),
    paymentType: 'bank_transfer',
    contractNumber: 'INV-2025-004',
    discount: 3,
  },
];
