# KeenIcons Reference Guide for Sidebar Menu

This document provides a comprehensive list of available KeenIcons from the KeenIcons library, organized by category for easy reference when building sidebar menus and navigation components.

## Usage

All icons can be used with the KeenIcons helper function:
```html
{{ theme.getKeenIcon('icon-name', 'classes') }}
```

Example:
```html
{{ theme.getKeenIcon('setting-2', 'text-muted-foreground text-lg') }}
```

---

## 🔧 Configuration & Settings Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `setting` | Basic settings gear | General settings, preferences |
| `setting-2` | Alternative settings icon | API settings, advanced config |
| `setting-3` | Third settings variant | System settings, admin panel |
| `setting-4` | Fourth settings variant | User settings, profile config |

---

## 👥 User & Team Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `user` | Single user icon | User profile, account |
| `users` | Multiple users/team icon | Team management, groups |
| `people` | Group of people | Community, members |
| `user-edit` | User with edit functionality | Edit profile, user management |
| `user-square` | User in square frame | User card, contact |
| `user-tick` | User with checkmark | Verified user, approved |
| `security-user` | User with security context | User permissions, access control |
| `profile-circle` | Profile in circle | Profile picture, avatar |

---

## 📊 Analytics & Data Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `chart` | Basic chart icon | General analytics |
| `chart-line` | Line chart | Trends, time series data |
| `chart-line-up` | Upward trending chart | Growth, positive trends |
| `chart-line-down` | Downward trending chart | Decline, negative trends |
| `chart-line-up-2` | Alternative upward chart | Performance metrics |
| `chart-line-down-2` | Alternative downward chart | Performance issues |
| `chart-line-star` | Chart with star indicator | Featured metrics, highlights |
| `chart-pie-3` | Pie chart variant | Distribution, proportions |
| `chart-pie-4` | Another pie chart variant | Data breakdown |
| `chart-pie-simple` | Simple pie chart | Basic statistics |
| `chart-pie-too` | Additional pie chart | Alternative statistics |
| `chart-simple` | Simple chart | Basic analytics |
| `chart-simple-2` | Simple chart variant | Quick stats |
| `chart-simple-3` | Another simple chart | Summary data |
| `bar-chart` | Bar chart | Comparisons, rankings |
| `data` | Data icon | Data management, datasets |

---

## 🔒 Security & Authentication Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `lock` | Basic lock | Security, protection |
| `lock-2` | Alternative lock | Access control, permissions |
| `lock-3` | Third lock variant | Advanced security |
| `shield` | Security shield | Security settings, protection |
| `shield-cross` | Shield with cross | Security alerts, warnings |
| `shield-search` | Shield with search | Security scanning, monitoring |
| `shield-slash` | Shield with slash | Security disabled, vulnerabilities |
| `shield-tick` | Shield with checkmark | Security verified, safe |
| `key` | Key icon | Authentication, login |
| `key-square` | Key in square | API keys, credentials |

---

## 📧 Communication Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `message-text` | Text message | Messages, chat |
| `message-text-2` | Alternative text message | Alternative messaging |
| `message-add` | Add message | Compose, new message |
| `message-edit` | Edit message | Edit, modify message |
| `message-minus` | Remove message | Delete message |
| `message-notify` | Notification message | Alerts, notifications |
| `message-programming` | Programming message | Technical support, code |
| `message-question` | Question message | Help, support |
| `messages` | Multiple messages | Message history, inbox |
| `notification` | Basic notification | General notifications |
| `notification-1` | Notification variant | Alternative notifications |
| `notification-bing` | Bing notification | Search notifications |
| `notification-circle` | Circular notification | Status notifications |
| `notification-favorite` | Favorite notification | Important alerts |
| `notification-on` | Active notification | Live notifications |
| `notification-status` | Status notification | System status |

---

## 📁 File & Document Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `file-added` | Added file | New files, uploads |
| `file-deleted` | Deleted file | Removed files, trash |
| `file-down` | Download file | Downloads, exports |
| `file-up` | Upload file | Uploads, imports |
| `file-left` | File left | File navigation |
| `file-right` | File right | File navigation |
| `file-sheet` | File sheet | Spreadsheets, reports |
| `files` | Multiple files | File management |
| `some-files` | Some files | Partial files |
| `add-files` | Add files | File creation |
| `delete-files` | Delete files | File removal |
| `update-file` | Update file | File modifications |
| `folder` | Basic folder | Directory, organization |
| `folder-added` | Added folder | New directories |
| `folder-down` | Download folder | Folder exports |
| `folder-up` | Upload folder | Folder imports |
| `add-folder` | Add folder | Create directory |
| `delete-folder` | Delete folder | Remove directory |
| `update-folder` | Update folder | Modify directory |
| `cloud-download` | Cloud download | Cloud storage, sync |

---

## 🏠 Navigation & Home Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `home` | Home icon | Dashboard, main page |
| `home-1` | Home variant 1 | Alternative home |
| `home-2` | Home variant 2 | Another home option |
| `home-3` | Home variant 3 | Third home option |
| `menu` | Menu icon | Navigation menu |
| `burger-menu` | Hamburger menu | Mobile menu |
| `burger-menu-1` | Burger menu variant 1 | Alternative menu |
| `burger-menu-2` | Burger menu variant 2 | Another menu option |
| `burger-menu-3` | Burger menu variant 3 | Third menu option |
| `burger-menu-4` | Burger menu variant 4 | Fourth menu option |
| `burger-menu-5` | Burger menu variant 5 | Fifth menu option |
| `burger-menu-6` | Burger menu variant 6 | Sixth menu option |

---

## 🔍 Search & Filter Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `magnifier` | Search magnifier | Search functionality |
| `search-list` | Search with list | Advanced search |
| `filter` | Basic filter | Filtering options |
| `filter-edit` | Edit filter | Filter management |
| `filter-search` | Search filter | Search filters |
| `filter-square` | Square filter | Filter options |
| `filter-tablet` | Tablet filter | Mobile filters |
| `filter-tick` | Filter with checkmark | Applied filters |

---

## 📱 Technology & Development Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `code` | Code icon | Development, programming |
| `html` | HTML icon | Web development |
| `css` | CSS icon | Styling, design |
| `js` | JavaScript icon | Frontend development |
| `js-2` | JavaScript variant | Alternative JS |
| `react` | React icon | React development |
| `angular` | Angular icon | Angular development |
| `vue` | Vue icon | Vue development |
| `ts` | TypeScript icon | TypeScript development |
| `python` | Python icon | Python development |
| `laravel` | Laravel icon | PHP/Laravel development |
| `bootstrap` | Bootstrap icon | UI framework |
| `github` | GitHub icon | Version control |
| `git` | Git icon | Source control |

---

## 🎨 Design & Creative Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `design-1` | Design icon 1 | Design tools |
| `design-2` | Design icon 2 | Alternative design |
| `figma` | Figma icon | Design software |
| `photoshop` | Photoshop icon | Image editing |
| `illustrator` | Illustrator icon | Vector graphics |
| `xd` | Adobe XD icon | UI/UX design |
| `brush` | Brush icon | Drawing, painting |
| `color-swatch` | Color swatch | Color management |
| `colors-square` | Color squares | Color palette |

---

## 💼 Business & Finance Icons

| Icon Name | Description | Usage |
|-----------|-------------|-------|
| `bank` | Bank icon | Banking, finance |
| `dollar` | Dollar icon | Currency, money |
| `euro` | Euro icon | European currency |
| `credit-cart` | Credit card | Payments, transactions |
| `two-credit-cart` | Two credit cards | Multiple payments |
| `wallet` | Wallet icon | Digital wallet |
| `bill` | Bill icon | Invoices, billing |
| `cheque` | Check icon | Payments, checks |
| `receipt-square` | Receipt | Transaction history |

---

## 📊 Current Layout-11 Menu Icons

Your current sidebar menu uses these icons:

### Configuration Section
- `setting-2` - API Setup
- `users` - Team Settings
- `mailbox` - Authentication
- `setting-2` - Endpoints Configs
- `chart-line` - Rate Limiting

### Security Section
- `globe-lock` - Data Encryption
- `gauge` - Rate Limiting (Security)
- `lock-keyhole-open` - Access Control
- `octagon-alert` - Incident Response

### Analytics Section
- `download` - Fetching Data
- `file-chart-line` - Custom Reports
- `square-activity` - Real Time Analytics

---

## 💡 Suggested Icon Improvements

Consider updating these icons for better semantic meaning:

| Current Icon | Suggested Icon | Reason |
|--------------|----------------|--------|
| `mailbox` (Authentication) | `lock` or `key` | More security-focused |
| `setting-2` (Endpoints Configs) | `setting-3` | Differentiate from API Setup |
| `gauge` (Rate Limiting Security) | `chart-line` | More consistent with Analytics |
| `download` (Fetching Data) | `data` | More appropriate for data operations |

---

## 🎯 Quick Reference by Category

### For Settings/Configuration
- `setting`, `setting-2`, `setting-3`, `setting-4`

### For User Management
- `user`, `users`, `people`, `user-edit`, `user-tick`

### For Analytics/Reports
- `chart`, `chart-line`, `chart-pie-3`, `bar-chart`, `data`

### For Security/Authentication
- `lock`, `lock-2`, `shield`, `key`, `security-user`

### For Communication
- `message-text`, `notification`, `notification-status`

### For File Management
- `file-up`, `file-down`, `folder`, `files`

### For Development
- `code`, `html`, `css`, `js`, `react`, `vue`

---

## 📝 Notes

- All icons are available in the KeenIcons library
- Use the `{{ theme.getKeenIcon() }}` helper function
- Icons support light/dark theme switching automatically
- Icons are optimized for performance and accessibility
- All icons follow consistent design patterns

---

*Last updated: Based on KeenIcons library version in the project*
